set term png
set out 'allLYsm.png'
set grid
set size 2
set style data lines

# Y  C  G  M
# 7  5  2  4
# 2  8 14 20

#C2Cc=1.06;   
#Gy2Gyc=1.24;
#M2Mc=1.31;

#f(x) = -2.5*ln( x * 9.25E-6 ) / ln10
f(x) = -1.0857 * log( x * 9.25E-6 )
#f(x) = x*1000
  

set title 'Sky Luminance (Kolonica site), smoothed, expressed as Faintness of 1 square second'
set ylabel 'Faintness / 1 mag'
set xlabel 'Angular distance from image center / 1 degree'
set xtics 10

set label  'No cSQM  time' at 61.7,21.22 


plot [1:70] [21.6:21.1] \
'25.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '25 21.24 23 h', \
'23.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '23 21.29 23 h', \
'38.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '38 21.29 02 h', \
'26.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '26 21.30 23 h', \
'40.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '40 21.30 00 h', \
'36.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '36 21.31 00 h', \
'28.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '28 21.39 01 h', \
'34.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '34 21.39 02 h', \
'35.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '35 21.40 02 h', \
'39.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '39 21.41 00 h', \
'32.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '32 21.47 02 h', \
'05.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '05 21.48 23 h', \
'27.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '27 21.48 01 h', \
'07.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '07 21.51 23 h', \
'30.rad' using ($1*1.8/pi):(f($3)) smooth bezier title '30 21.52 02 h'
 

#   S 1.09 25   S 1.25 26
#  S 0.95 27  S 1.15 28   S 0.75 30  S 0.85 32  S 1.08 34 \
#   S 0.92 35  S 1.03 38   S 1.28 39 
