# Assembling all all-sky maps for a given latitude to a single pdf
#  The dates have been written manually, it might be nice to produce them 
#  by adapting the allsky.sh script

# each new year, the sets of dates and of *.pdf for pdftk, below, are to be renewed. 
#  By dates.txt and by MonDaLat.txt

LC_ALL="C"

Ye=2026

mkdir latitudes

cd latitudes

 for L in 50s 40s 30s 20s 10s 0 10 20 30 40 50 60
 do

  LA=${L}A
  
  mkdir $L 
  cd $L

#  for ZE in 25 40
#  do 

for MoDa in \
01-15 \
02-14 \
03-15 \
04-14 \
05-13 \
06-11 \
07-11 \
08-09 \
09-07 \
10-07 \
11-06 \
12-05



do
 Mo=${MoDa/-[0-9][0-9]}
 Da=${MoDa/[0-9][0-9]-}
#echo $Mo $Da

MoNDa=`date --date=$Ye-$MoDa +%b%d`
#echo ${MoNDa}*.pdf \\ >>MonDa.txt

  
    if [ -f ../../$MoNDa/A/$LA.pdf ] 
    then
    ln -s ../../$MoNDa/A/$LA.pdf  ${MoNDa}${LA}.pdf 
    fi
done
  
   pdftk \
Jan15${LA}.pdf \
Feb14${LA}.pdf \
Mar15${LA}.pdf \
Apr14${LA}.pdf \
May13${LA}.pdf \
Jun11${LA}.pdf \
Jul11${LA}.pdf \
Aug09${LA}.pdf \
Sep07${LA}.pdf \
Oct07${LA}.pdf \
Nov06${LA}.pdf \
Dec05${LA}.pdf \
cat output ${LA}.pdf

    rm \
Jan15${LA}.pdf \
Feb14${LA}.pdf \
Mar15${LA}.pdf \
Apr14${LA}.pdf \
May13${LA}.pdf \
Jun11${LA}.pdf \
Jul11${LA}.pdf \
Aug09${LA}.pdf \
Sep07${LA}.pdf \
Oct07${LA}.pdf \
Nov06${LA}.pdf \
Dec05${LA}.pdf \

  cd ..

 done

cd ..
