#!/bin/bash

#  this is THE FIRST SCRIPT to be RUN!

# Creates directories for all months-dates named in the cycle set, symlinks ##-##, 
# and produces all sky maps for latitudes -50 to 60 for 21 h local mean time

# once more, trying to get 16 pt at <350 cmag

# and changing Toliman to \alpha Cen - will be applied for 2021

LC_ALL="C"

Ye=2026

for MoDa in \
01-15 \
02-14 \
03-15 \
04-14 \
05-13 \
06-11 \
07-11 \
08-09 \
09-07 \
10-07 \
11-06 \
12-05


do
 Mo=${MoDa/-[0-9][0-9]}
 Da=${MoDa/[0-9][0-9]-}
echo $Mo $Da $Da0

MoNDa=`date --date=$Ye-$MoDa +%b%d`
echo $MoNDa0

mkdir $MoNDa
ln -s $MoNDa .$MoDa
cd .$MoDa
mkdir A
cd A 

onemap (){
Md=${Mc/50/5}
map_bsct wPmap.eps d$Da.$Mo.$Ye t21:00 l0 f$F ut0 np pl+ \
        ne nz  m$Mc b-$B         $HI ndp z25 oobj2014:r plf


if (( $Md > 35 ))
then
 sed -r "
  /Jupiter|Saturn|Mars|Antares|Regulus|Denebola|Vega|Altair/d
  /Deneb|Enif|Fomalhaut|Pollux|Procyon|Capella|Betelgeuse|Toliman/d
  /Sheliak|Algol|Pleiades|Hyades|Big Dipper|T CrB|Arcturus|Sirius/d
  /Achernar|Canopus|Rigel|Mira|\)21:0/d
  " map.eps >map2.eps
else
 sed -r "
 /r  % setting initial font/{s/^r/RR/}
  " map.eps >map2.eps
  
fi
 mv map2.eps map.eps

	
sed -r "
 s/Toliman/Alpha Centauri/
 s/Alpha Centauri\) trdr/A Cen\) nc xw add exch sh 1.25 mul add moveto pop  \/sh H 3 div neg def \/Symbol sh sf  \(a \) show RR \(Cen\) show grestore /
 /^% cross at the ecliptics/,+2 d
 /[0-9]+-[0-9]+ lineto/d
 /\/H 10 def/{s/H 10 def/H 12 def/}
 /T CrB/d
 /% 5958/d
 /$T/{s/(^[0-9]+ +[0-9]+ +)/\1-/; s/trdlw/trdr/}
 /$T2/{s/(^[0-9]+ +[0-9]+ +)/\1-/; s/trdlw/trdr/}
 /$TL/{s/trdr/trdl/; s/-//}
 /Alp CMa|32325/{s/ star/ 0 tstar/}
 /Alp Ori/{s/ vstar/ star/}
 /vstar % 25912/{s/ vstar/ star/}
 /\(wPmap.+\)/{
   s/\(wPmap.+\)/\(< $M mag; lat. $F, $Ye-$Mo-$Da, 21 h local time\)/
   }" map.eps >${Ft}_${Md}.eps

epstopdf ${Ft}_${Md}.eps

}


cone () {

HI=

R=40

B=460
Mc=050
M=0.50
onemap

B=420
Mc=150
M=1.50
onemap

B=380
Mc=250
M=2.50
onemap

B=340
Mc=350
M=3.50
onemap

B=300
Mc=450
M=4.50
onemap

B=260
Mc=550
M=5.50
onemap


R=20

sleep 2

#rm map.eps

pdftk ${Ft}_*.pdf cat output ${Ft}A.pdf
rm ${Ft}_*.pdf

}

# these strings are for ev. putting the labels on the other side
TC="blablabla"
TL=$TC
T=$TC
T2=$TC



F=-50
Ft=${F/-}s
cone

F=-40
Ft=${F/-}s
cone


F=-30
Ft=${F/-}s
cone


F=-20
Ft=${F/-}s
cone

F=-10
Ft=${F/-}s
cone

for F in 0 10 20 30 40 50 60 
do 
 Ft=$F
# if (($F = 30 & $MoDa = "01-10")) 
# then 
#  T="Rigel" 
# else 
#  T=$TC 
# fi
 cone
done

sleep 2

rm *.eps

cd ../../

done
