#!/bin/bash

# Edited from a template to start at lat. -20 and to have all radii 50 degrees
# A new variable TL and a constant TC added, to shift planet string to the other side 

YMD="2025-08-19"
Date=d`date --date=$YMD +%-d.%-m.%Y`
Time="t21:00"
TimeT="21 h"
 #later for 60 deg
ZE=25


ah (){
star_pos nBet_Cyg $Date $Time l0 f$F ut0 > F.txt
A=`sed -rn  "/and azimuth:/{s/[^0-9]+([0-9]+.[0-9]+).*/\1/p}" F.txt`
H=`sed -rn  "/height/{s/[^0-9]+([0-9]+.[0-9]+).*/\1/p}" F.txt`
Aint=`calc -p -q "round($A)"`
Hint=`calc -p -q "round($H)"`
D=`calc -q -p "2*$R"`
mAA=`calc -q -p "180-$A"`

if ((  $Aint \> 90 ))
then
 if ((  $Aint \< 180 ))
 then
  AT="to the left from S"
  Aint=`calc -p -q "180-$Aint"`
 elif ((  $Aint \< 270 )) 
  then
  AT="to the right from S"
  Aint=`calc -p -q "$Aint-180"`
  else 
  AT="to the left from N"
  Aint=`calc -p -q "360-$Aint"`
 fi 
else
  AT="to the right from N"
fi

sun $Date $Time l0 f$F ut0 | grep height | \
 sed "s/^M//; s/Ang/Sun ang/ " >>F.txt
nons2bla F.txt 176 >/dev/null 
HS=`sed -rn  "/Sun/{s/[^0-9]+([0-9]+\.[0-9]).*/\1/p}" F.txt`
HSint=`calc -p -q "round($HS)"`

Zint=`calc -p -q "round(90-$H)"`


}

onemap (){
Md=${Mc/50/5}

if (( $Zint \< $R ))
then
 K=0
 Y=`calc -p -q "$H-90"`
 AoRo="ro$mAA"
else 
 K="cone$H"
 Y=0
 AoRo="A$A"
fi 


#map_bsct wPmap.eps d30.3.2011 t21:00 l0 f$F ut0 np nz \
#kcone$H ne m$Mc b-$B r16.5 y0 ys60 xs65 tr13 $HI ndp z25  A$A

#map_bsct wPmap.eps d30.3.2011 t21:00 l0 f$F ut0 np pl \
#k0      ne m$Mc b-$B r20 y-$Z ys60 xs65 tr13 $HI ndp z25 ro$mAA

#map_bsct wPmap.eps d30.3.2011 t21:00 l0 f$F ut0 np pl+ \
#kcone$H ne nz m$Mc b-$B r$R y0 ys60 xs65 tr13 $HI ndp z25  A$A oobjb:r plf

 map_bsct wPmap.eps $Date $Time l0 f$F ut0 np hc pl+ nz \
 k$K     ne    m$Mc b-$B r$R y$Y  ys60 xs65 tr13 $HI ndp z$ZE $AoRo \
 oobj2014:r plf nib $Conf




# the full set of star names in obj2014:r (and of bright planets) - all are to be discarded in maps over 4.5 mag
#  (a former, limited list, amended to a full one using dbview, Dec 2016):
if (( $Md \> 45 ))
then
 sed -r "
  /Jupiter|Saturn|Mars|Venus/d
  /Mira|Algol|Pleiades|Hyades|Rigel|Capella|Betelgeuse/d
  /Sirius|Procyon|Pollux|Big Dipper|Arcturus|T CrB|Antares/d
  /Vega|Sheliak|Altair|Deneb|Enif|Fomalhaut|Canopus|Achernar/d
  /Toliman|Regulus|Denebola/d
  " map.eps >map2.eps
 mv map2.eps map.eps
fi



sed -r "
 /[0-9]+-[0-9]+ lineto/d
 /\/H 10 def/{s/H 10 def/H 12 def/}
 /r  % setting initial font/{s/^r/RR/}
 /Alp CMa|32325/{s/ star/ 0 tstar/}
 /Alp Ori/{s/ vstar/ star/}
 /T CrB/d
 /Sheliak/d
 /% 5958/d
 /vstar % 25912/{s/ vstar/ star/}
 /$T/{s/(^[0-9]+ +[0-9]+ +)/\1-/; s/trdlw/trdr/}
 /$TL/{s/trdr/trdl/; s/-//}
 /\(wPmap.+\)/{s/\(wPmap.+\)/\(< $M mag\)/}
    0,/ Deep-sky/ {s/ Deep-sky/1Deep-sky/}
   / Deep-sky/,/Six planets/ {d} 
 " map.eps >${Ft}_$Md.eps

# the last two lines avoid plotting deep-sky object labels twice

 

epstopdf ${Ft}_$Md.eps

}


cone () {

#R=50
R=25
HI=
ah

#Conf="kconf"
Conf=

B=430
Mc=050
M=0.50
onemap

B=390
Mc=150
M=1.50
onemap

B=350
Mc=250
M=2.50
onemap

B=310
Mc=350
M=3.50
onemap

R=25
Conf=

B=270
Mc=450
M=4.50
onemap

B=230
Mc=550
M=5.50
onemap

HI=hi/home/jhollan/www/data/

B=190
Mc=650
M=6.50
onemap

B=150
Mc=750
M=7.50
onemap

sleep 2

rm map.eps

sed -r "
s/20_/${Ft}_/
/latitude/{s/20/$F/}
s/^51/${Aint}/
s/^at 58/at ${Hint}/
/Sun at/{s/x/${HSint}/}
s/to the left from the south/$AT/
s/YYYY-MM-DD/$YMD/
s/21 h/$TimeT/
" To_Edit.tex >$Ft.tex

pdflatex $Ft.tex
rm $Ft.log
rm $Ft.aux
rm $Ft.out

mv ${Ft}_*.* single/
mv $Ft.tex single/
}

if [ ! -d single ]
then
 mkdir single
fi

TC="blablabla"
TL=$TC
T=$TC

F=-30
Ft=${F/-}s
T="Enif"
cone


F=-20
Ft=${F/-}s
cone

F=-10
Ft=${F/-}s
T=$TC
cone

F=0
Ft=$F
cone

F=10
Ft=$F
cone

F=20
Ft=$F
cone

F=30
Ft=$F
cone

F=40
Ft=$F
T="Deneb"
cone


#Time="t22:00"
#TimeT="22 h"

F=50
Ft=$F
T=$TC
cone

Time="t21:30"
TimeT="21:30 h"

F=60
Ft=$F
cone

pdftk 60.pdf 50.pdf 40.pdf 30.pdf  20.pdf 10.pdf 0.pdf  *s.pdf \
 cat output all.pdf

rm F.txt
